/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.biomesoplenty;

import biomesoplenty.api.biome.BOPBiomes;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.realistic.biomesoplenty.RealisticBiomeBOPBase;

public class RealisticBiomeBOPCrag
extends RealisticBiomeBOPBase {
    public static Biome biome = (Biome)BOPBiomes.crag.orNull();
    public static Biome river = Biomes.field_76781_i;

    public RealisticBiomeBOPCrag() {
        super(biome);
    }

    @Override
    public Biome preferredBeach() {
        return biome;
    }

    @Override
    public void initConfig() {
        this.getConfig().ALLOW_RIVERS.set(false);
        this.getConfig().ALLOW_SCENIC_LAKES.set(false);
        this.getConfig().addProperty(this.getConfig().SURFACE_MIX_BLOCK).set("");
        this.getConfig().addProperty(this.getConfig().SURFACE_MIX_2_BLOCK).set("");
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBOPCrag(false, new float[]{2.0f, 0.5f, 6.5f, 0.5f, 14.0f, 0.5f, 19.0f, 0.5f, 23.0f, 0.5f}, 35.0f, 80.0f, 60.0f, 40.0f, 69.0f);
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceBOPCrag(this.getConfig(), Blocks.field_150348_b.func_176223_P(), Blocks.field_150348_b.func_176223_P(), 0.0f, 1.5f, 60.0f, 65.0f, 1.8f, Blocks.field_150349_c.func_176223_P(), 1.9f, Blocks.field_150351_n.func_176223_P(), -0.4f);
    }

    public static class SurfaceBOPCrag
    extends SurfaceBase {
        private float min;
        private float sCliff = 1.5f;
        private float sHeight = 60.0f;
        private float sStrength = 65.0f;
        private float cCliff = 1.5f;
        private IBlockState mixBlock;
        private float mixHeight;
        private IBlockState mix2Block;
        private float mix2Height;

        public SurfaceBOPCrag(BiomeConfig config, IBlockState top, IBlockState fill, float minCliff, float stoneCliff, float stoneHeight, float stoneStrength, float clayCliff, IBlockState mix, float mixHeight, IBlockState mix2, float mix2Height) {
            super(config, top, fill);
            this.min = minCliff;
            this.sCliff = stoneCliff;
            this.sHeight = stoneHeight;
            this.sStrength = stoneStrength;
            this.cCliff = clayCliff;
            this.mixBlock = this.getConfigBlock(config.SURFACE_MIX_BLOCK.get(), mix);
            this.mixHeight = mixHeight;
            this.mix2Block = this.getConfigBlock(config.SURFACE_MIX_2_BLOCK.get(), mix2);
            this.mix2Height = mix2Height;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            int cliff = 0;
            boolean m = false;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (++depth == 0) {
                    float p = simplex.noise3f((float)i / 8.0f, (float)j / 8.0f, (float)k / 8.0f) * 0.5f;
                    if (c > this.min && c > this.sCliff - ((float)k - this.sHeight) / this.sStrength + p) {
                        cliff = 1;
                    }
                    if (c > this.cCliff) {
                        cliff = 2;
                    }
                    if (cliff == 1) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (cliff == 2) {
                        primer.func_177855_a(x, k, z, this.getShadowStoneBlock());
                        continue;
                    }
                    if (k < 63) {
                        if (k < 62) {
                            primer.func_177855_a(x, k, z, this.fillerBlock);
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.topBlock);
                        continue;
                    }
                    float mixNoise = simplex.noise2f((float)i / 12.0f, (float)j / 12.0f);
                    if (mixNoise < this.mix2Height) {
                        primer.func_177855_a(x, k, z, this.mix2Block);
                        m = true;
                        continue;
                    }
                    if (mixNoise > this.mixHeight) {
                        primer.func_177855_a(x, k, z, this.mixBlock);
                        m = true;
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 6) continue;
                if (cliff == 1) {
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (cliff == 2) {
                    primer.func_177855_a(x, k, z, this.getShadowStoneBlock());
                    continue;
                }
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }

        @Override
        protected IBlockState getShadowStoneBlock() {
            return Blocks.field_150347_e.func_176223_P();
        }

        @Override
        protected IBlockState hcCobble() {
            return Blocks.field_150348_b.func_176223_P();
        }
    }

    public static class TerrainBOPCrag
    extends TerrainBase {
        private boolean booRiver;
        private float[] height;
        private int heightLength;
        private float strength;
        private float cWidth;
        private float cHeigth;
        private float cStrength;
        private float base;

        public TerrainBOPCrag(boolean riverGen, float[] heightArryay, float heightStrength, float canyonWidth, float canyonHeight, float canyonStrength, float baseHeight) {
            this.booRiver = riverGen;
            this.height = heightArryay;
            this.strength = heightStrength;
            this.heightLength = this.height.length;
            this.cWidth = canyonWidth;
            this.cHeigth = canyonHeight;
            this.cStrength = canyonStrength;
            this.base = baseHeight;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            river = (river *= 1.3f) > 1.0f ? 1.0f : river;
            float r = simplex.noise2f((float)x / 100.0f, (float)y / 100.0f) * 50.0f;
            r = r < -7.4f ? -7.4f : (r > 7.4f ? 7.4f : r);
            float b = (17.0f + r) * river;
            float hn = simplex.noise2f((float)x / 12.0f, (float)y / 12.0f) * 0.5f;
            float sb = 0.0f;
            if (b > 0.0f) {
                sb = b;
                sb = sb < 0.0f ? 0.0f : (sb > 7.0f ? 7.0f : sb);
                sb = hn * sb;
            }
            b += sb;
            float cTotal = 0.0f;
            float cTemp = 0.0f;
            for (int i = 0; i < this.heightLength; i += 2) {
                cTemp = 0.0f;
                if (b > this.height[i] && border > 0.6f + this.height[i] * 0.015f + hn * 0.2f) {
                    cTemp = b > this.height[i] + this.height[i + 1] ? this.height[i + 1] : b - this.height[i];
                    cTemp *= this.strength;
                }
                cTotal += cTemp;
            }
            float bn = 0.0f;
            if (this.booRiver) {
                if (b < 5.0f) {
                    bn = 5.0f - b;
                    for (int i = 0; i < 3; ++i) {
                        bn *= bn / 4.5f;
                    }
                }
            } else if (b < 5.0f) {
                bn = (simplex.noise2f((float)x / 7.0f, (float)y / 7.0f) * 1.3f + simplex.noise2f((float)x / 15.0f, (float)y / 15.0f) * 2.0f) * (5.0f - b) * 0.2f;
            }
            return this.base + (b += cTotal - bn);
        }
    }
}

